import type { Metadata } from "next"
import { Suspense } from "react"
import { HotelPartnersClient } from "@/components/admin/hotel-partners/hotel-partners-client"
import { Skeleton } from "@/components/ui/skeleton"

export const metadata: Metadata = {
  title: "Hotel Partners | Teertham Admin",
  description:
    "Manage approved hotel partners on the Teertham platform. View, add, edit, and manage hotel partner accounts and their documentation.",
  openGraph: {
    title: "Hotel Partners | Teertham Admin",
    description: "Manage approved hotel partners on the Teertham platform.",
    type: "website",
  },
  twitter: {
    card: "summary",
    title: "Hotel Partners | Teertham Admin",
    description: "Manage approved hotel partners on the Teertham platform.",
  },
  robots: {
    index: false,
    follow: false,
  },
}

function HotelPartnersSkeleton() {
  return (
    <div className="space-y-6">
      <div className="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <div className="space-y-2">
          <Skeleton className="h-8 w-48" />
          <Skeleton className="h-4 w-72" />
        </div>
        <Skeleton className="h-10 w-40" />
      </div>
      <Skeleton className="h-10 w-80" />
      <div className="space-y-4">
        {Array.from({ length: 5 }).map((_, i) => (
          <Skeleton key={i} className="h-16 w-full" />
        ))}
      </div>
    </div>
  )
}

export default function HotelPartnersPage() {
  return (
    <main>
      <Suspense fallback={<HotelPartnersSkeleton />}>
        <HotelPartnersClient />
      </Suspense>

      {/* JSON-LD Schema */}
      <script
        type="application/ld+json"
        dangerouslySetInnerHTML={{
          __html: JSON.stringify({
            "@context": "https://schema.org",
            "@type": "WebPage",
            name: "Hotel Partners Management",
            description: "Admin page for managing hotel partners on Teertham platform",
            isPartOf: {
              "@type": "WebApplication",
              name: "Teertham Admin",
            },
          }),
        }}
      />
    </main>
  )
}
