"use client"

import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { Avatar, AvatarFallback } from "@/components/ui/avatar"
import { Clock, Users } from "lucide-react"

const upcomingCheckIns = [
  {
    id: "BK101",
    guestName: "Arun Mehta",
    roomType: "Deluxe Suite",
    checkInTime: "2:00 PM",
    guests: 2,
    status: "confirmed",
  },
  {
    id: "BK102",
    guestName: "Kavitha Nair",
    roomType: "Premium Room",
    checkInTime: "3:30 PM",
    guests: 3,
    status: "confirmed",
  },
  {
    id: "BK103",
    guestName: "Sanjay Patel",
    roomType: "Standard Room",
    checkInTime: "4:00 PM",
    guests: 1,
    status: "pending",
  },
]

export function UpcomingCheckIns() {
  return (
    <Card className="border bg-card">
      <CardHeader className="pb-3">
        <CardTitle className="text-lg font-semibold flex items-center gap-2">
          <Clock className="h-5 w-5 text-muted-foreground" />
          Today&apos;s Check-ins
        </CardTitle>
      </CardHeader>
      <CardContent className="space-y-3">
        {upcomingCheckIns.map((checkIn) => (
          <div key={checkIn.id} className="flex items-center gap-3 p-3 rounded-lg bg-muted/30 border border-border/50">
            <Avatar className="h-10 w-10 border">
              <AvatarFallback className="bg-slate-100 dark:bg-slate-800 text-slate-600 dark:text-slate-300 font-medium text-sm">
                {checkIn.guestName
                  .split(" ")
                  .map((n) => n[0])
                  .join("")}
              </AvatarFallback>
            </Avatar>
            <div className="flex-1 min-w-0">
              <p className="font-medium text-sm truncate">{checkIn.guestName}</p>
              <p className="text-xs text-muted-foreground">{checkIn.roomType}</p>
            </div>
            <div className="text-right">
              <Badge
                variant="outline"
                className={
                  checkIn.status === "confirmed"
                    ? "bg-emerald-50 text-emerald-600 border-emerald-200 dark:bg-emerald-950 dark:text-emerald-400 dark:border-emerald-800"
                    : "bg-amber-50 text-amber-600 border-amber-200 dark:bg-amber-950 dark:text-amber-400 dark:border-amber-800"
                }
              >
                {checkIn.checkInTime}
              </Badge>
              <p className="text-xs text-muted-foreground mt-1 flex items-center justify-end gap-1">
                <Users className="h-3 w-3" /> {checkIn.guests}
              </p>
            </div>
          </div>
        ))}
      </CardContent>
    </Card>
  )
}
