import { z } from "zod"
import DOMPurify from "dompurify"

const sanitize = (value: string) => DOMPurify.sanitize(value.trim())

export const routeVehicleSchema = z.object({
  vehicleId: z.string().min(1, "Please select a vehicle"),
  vehicleName: z.string().min(1, "Vehicle name is required"),
  vehicleCategory: z.string().min(1, "Vehicle category is required"),
  vehiclePhoto: z.string().min(1, "Vehicle photo is required"),
  basePerKmRate: z.number().min(1, "Base rate must be at least ₹1"),
  routePerKmRate: z.number().min(1, "Route rate must be at least ₹1"),
})

export const routeSchema = z.object({
  originCityId: z.string().min(1, "Please select origin city"),
  destinationCityId: z.string().min(1, "Please select destination city"),
  vehicles: z.array(routeVehicleSchema).optional(),
})

export type RouteInput = z.infer<typeof routeSchema>
export type RouteVehicleInput = z.infer<typeof routeVehicleSchema>
